﻿Imports System.Net
Imports System.Collections.Specialized

Public Class Form1
    Dim TAB As String = Chr(9)

    ' iMUIS Online: demo.imuisonline.com
    ' username voor iMUIS Online: 
    ' password voor iMUIS Online: 
    ' administratie: 

    ' Partnerkey is uniek voor jullie.
    Dim partnerkey As String = "abcdefghijklmnopqrstuvwxyz" ' "abcdefghijklmnopqrstuvwxyz" ' partnerkey tbv ontwikkeling
    Dim omgevingscode_demoadministratie As String = "00000" ' "00000" ' omgevingscode tbv ontwikkeling

    Private Sub btnLogin_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLogin.Click
        If String.IsNullOrEmpty(txtPartnerKey.Text) Then MsgBox("PartnerKey moet ingevuld zijn") : Exit Sub
        If String.IsNullOrEmpty(txtOmgevingsCode.Text) Then MsgBox("Omgevingscode moet ingevuld zijn") : Exit Sub

        If Not String.IsNullOrEmpty(txtSessionId.Text) Then Logout(txtSessionId.Text)

        txtSessionId.Text = ""
        txtPrimarykey.Text = ""

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim aSessionId As String = ""
                Dim foutmelding As String = ""
                If Not ws1.Login(txtPartnerKey.Text, txtOmgevingsCode.Text, aSessionId, foutmelding) Then
                    MsgBox("Login mislukt: " + foutmelding)
                Else
                    txtSessionId.Text = aSessionId
                    KeepSession()
                End If
            Case "XML"

            Case "API"
                ' via HTTP call.

                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "LOGIN")

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Login mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                txtSessionId.Text = ds_return.Tables("SESSION").Rows(0)("SESSIONID")
                                KeepSession()
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Public Function KeepSession() As Boolean
        If Not String.IsNullOrEmpty(txtSessionId.Text) And Not String.IsNullOrEmpty(txtPartnerKey.Text) And Not String.IsNullOrEmpty(txtOmgevingsCode.Text) Then
            Select Case combometh.SelectedItem
                Case "SOAP"
                    Dim ws1 As New ws1.ws1
                    Dim aSessionId As String = txtSessionId.Text
                    Dim foutmelding As String = ""
                    If Not ws1.KeepSession(txtPartnerKey.Text, txtOmgevingsCode.Text, aSessionId, foutmelding) Then
                        MsgBox("KeepSession mislukt: " + foutmelding)
                    Else
                        lblKeepSession.Text = "Laatste keepsession uitgevoerd: " + Now.ToString
                    End If
                Case "API"
                    Dim valuecollection As New NameValueCollection
                    valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                    valuecollection.Add("ACTIE", "KEEPSESSION") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                    Try
                        Using client As New Net.WebClient
                            Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                            Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                            Dim ds_return As New DataSet
                            Try
                                ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                If ds_return.Tables.Contains("ERROR") Then
                                    MsgBox("Keepsession mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                                Else
                                    lblKeepSession.Text = "Laatste keepsession uitgevoerd: " + Now.ToString
                                End If
                            Catch ex As Exception
                                MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                            End Try
                        End Using
                    Catch ex As Exception

                    End Try
            End Select
        End If
    End Function

    Public Function Logout(ByVal sessionid As String) As Boolean
        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                If Not ws1.Logout(txtPartnerKey.Text, txtOmgevingsCode.Text, sessionid, foutmelding) Then
                    MsgBox("Logout mislukt: " + foutmelding)
                    Return False
                Else
                    txtSessionId.Text = ""
                    lblKeepSession.Text = ""
                    Return True
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "LOGOUT") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Logout mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                txtSessionId.Text = ""
                                lblKeepSession.Text = ""
                                Return True
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Function

    Private Sub btnLogout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLogout.Click
        DataGridView1.Columns.Clear()

        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
        Logout(txtSessionId.Text)
    End Sub

    Private Sub btnMaakJournaalpost_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMaakJournaalpost.Click, btnJournaalpostJSON.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim ds_journaalpost As New DataSet
        Dim dt_journaalpost As DataTable = ds_journaalpost.Tables.Add
        dt_journaalpost.TableName = "BOE"
        dt_journaalpost.Columns.Add("JR", GetType(System.Int32)).DefaultValue = Now.Year
        dt_journaalpost.Columns.Add("PN", GetType(System.Int32)).DefaultValue = Now.Month
        dt_journaalpost.Columns.Add("DAGB", GetType(System.Int32)).DefaultValue = 20
        dt_journaalpost.Columns.Add("REK", GetType(System.Int32)).DefaultValue = 20000
        dt_journaalpost.Columns.Add("FACT", GetType(System.Int32)).DefaultValue = 0
        dt_journaalpost.Columns.Add("TEGREK", GetType(System.Int32)).DefaultValue = 4200 ' splitsingsrekening in demo-administratie.
        dt_journaalpost.Columns.Add("BTW", GetType(System.Int32)).DefaultValue = 4
        dt_journaalpost.Columns.Add("BEDRBOEK", GetType(System.Double)).DefaultValue = "1.000,00" ' -121
        dt_journaalpost.Columns.Add("BEDRBTW", GetType(System.Double)).DefaultValue = 21
        dt_journaalpost.Columns.Add("DAT", GetType(System.String)).DefaultValue = "01-02-" + Now.Year.ToString
        dt_journaalpost.Columns.Add("OPM", GetType(System.String)).DefaultValue = "Opmerking"
        dt_journaalpost.Columns.Add("OMSCHR", GetType(System.String)).DefaultValue = "Omschrijving"
        dt_journaalpost.Columns.Add("BOEKSTUK", GetType(System.String)).DefaultValue = "1000"
        dt_journaalpost.Columns.Add("KPL", GetType(System.Int32)).DefaultValue = 0
        dt_journaalpost.Columns.Add("KDR", GetType(System.Int32)).DefaultValue = 0
        Dim dr_journaalpost = dt_journaalpost.NewRow : dt_journaalpost.Rows.Add(dr_journaalpost)

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                If chkdigdos.Checked Then
                    Dim dt_digdos As DataTable = ds_journaalpost.Tables.Add
                    dt_digdos.TableName = "DIGDOS"
                    dt_digdos.Columns.Add("FILE", GetType(System.Byte()))
                    Dim dr_digdos = dt_digdos.NewRow

                    Dim dir_ori As String = Environment.CurrentDirectory
                    ChDir(Environment.CurrentDirectory.Substring(0, Environment.CurrentDirectory.LastIndexOf("\")))
                    ChDir(Environment.CurrentDirectory.Substring(0, Environment.CurrentDirectory.LastIndexOf("\")))
                    dr_digdos("FILE") = System.IO.File.ReadAllBytes(System.IO.Path.Combine(Environment.CurrentDirectory, "voorbeeldbijlage.pdf"))
                    ChDir(dir_ori)

                    dt_digdos.Rows.Add(dr_digdos)
                End If

                Dim MessageId() As String = Nothing
                Dim aDatStart As DateTime = Now
                For teller As Integer = 0 To 100
                    If Not ws1.CreateJournaalpost(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_journaalpost, MessageId, foutmelding) Then
                        MsgBox(foutmelding) : Exit Sub
                    End If
                Next
                Dim aDatStop As DateTime = Now

                MsgBox(DateDiff(DateInterval.Second, aDatStart, aDatStop))

                Exit Sub


                If Not ws1.CreateJournaalpost(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_journaalpost, MessageId, foutmelding) Then
                    MsgBox("Journaalpost mislukt: " + foutmelding)
                Else
                    Dim dt_journaalpost_return As DataTable = ds_journaalpost.Tables("BOE")
                    MsgBox("Journaalpost geboekt: " + MessageId.Length.ToString + " regel.")
                    txtPrimarykey.Text = MessageId(0).ToString
                    txtFactNr.Text = ds_journaalpost.Tables(0).Rows(0)("FACT")
                    txtOmschr.Enabled = True : btnPasJournaalpostAan.Enabled = True : btnDeleteJournaalpost.Enabled = True
                    If dt_journaalpost_return.Columns.Contains("BOE_WARNING") Then MsgBox("Warning uit administratie: " + dt_journaalpost_return.Rows(0)("BOE_WARNING"))
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim foutmelding As String = ""

                Dim MessageId() As String = Nothing

                Dim sw As New IO.StringWriter
                ds_journaalpost.WriteXml(sw)
                Dim xml_journaalpost As String = sw.ToString

                If Not ws1_xml.CreateJournaalpost(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, xml_journaalpost, MessageId, foutmelding) Then
                    MsgBox("Journaalpost mislukt: " + foutmelding)
                Else
                    MsgBox("Journaalpost geboekt: " + MessageId.Length.ToString + " regel.")
                    txtPrimarykey.Text = MessageId(0).ToString

                    ds_journaalpost = New DataSet
                    ds_journaalpost.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(xml_journaalpost)))
                    Dim dt_journaalpost_return As DataTable = ds_journaalpost.Tables("BOE")

                    txtFactNr.Text = dt_journaalpost_return.Rows(0)("FACT")
                    txtOmschr.Enabled = True : btnPasJournaalpostAan.Enabled = True : btnDeleteJournaalpost.Enabled = True
                    If dt_journaalpost_return.Columns.Contains("BOE_WARNING") Then MsgBox("Warning uit administratie: " + dt_journaalpost_return.Rows(0)("BOE_WARNING"))
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "CREATEJOURNAALPOST") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim MessageId() As String = Nothing

                Dim sw As New IO.StringWriter
                ds_journaalpost.WriteXml(sw)
                Dim xml_journaalpost As String = sw.ToString

                valuecollection.Add("JOURNAALPOST", xml_journaalpost)

                If chkdigdos.Checked Then
                    Dim dir_ori As String = Environment.CurrentDirectory
                    ChDir(Environment.CurrentDirectory.Substring(0, Environment.CurrentDirectory.LastIndexOf("\")))
                    ChDir(Environment.CurrentDirectory.Substring(0, Environment.CurrentDirectory.LastIndexOf("\")))
                    valuecollection.Add("FILE", Convert.ToBase64String(System.IO.File.ReadAllBytes(System.IO.Path.Combine(Environment.CurrentDirectory, "voorbeeldbijlage.pdf"))))
                    ChDir(dir_ori)
                End If

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Journaalpost mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ReDim MessageId(0)
                                For Each dr As DataRow In ds_return.Tables("PRIMARYKEYS").Rows
                                    MessageId(MessageId.Length - 1) = dr("PRIMARYKEY")
                                Next
                                MsgBox("Journaalpost geboekt: " + MessageId.Length.ToString + " regel.")
                                txtPrimarykey.Text = MessageId(0).ToString

                                ds_journaalpost = New DataSet
                                ds_journaalpost.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(xml_journaalpost)))
                                Dim dt_journaalpost_return As DataTable = ds_return.Tables("BOE")

                                txtFactNr.Text = dt_journaalpost_return.Rows(0)("FACT")
                                txtOmschr.Enabled = True : btnPasJournaalpostAan.Enabled = True : btnDeleteJournaalpost.Enabled = True
                                If dt_journaalpost_return.Columns.Contains("BOE_WARNING") Then MsgBox("Warning uit administratie: " + dt_journaalpost_return.Rows(0)("BOE_WARNING"))
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub btnMeerdereJournaalposten_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMeerdereJournaalposten.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
        txtPrimarykey.Text = "" : txtOmschr.Enabled = False : btnPasJournaalpostAan.Enabled = False : btnDeleteJournaalpost.Enabled = False

        Dim ws1 As New ws1.ws1
        Dim foutmelding As String = ""
        Dim ds_records As New DataSet

        Dim ds_journaalpost As New DataSet
        Dim dt_journaalpost As DataTable = ds_journaalpost.Tables.Add
        dt_journaalpost.TableName = "BOE"
        dt_journaalpost.Columns.Add("JR", GetType(System.Int32)).DefaultValue = Now.Year
        dt_journaalpost.Columns.Add("PN", GetType(System.Int32)).DefaultValue = Now.Month
        dt_journaalpost.Columns.Add("DAGB", GetType(System.Int32)).DefaultValue = 70
        dt_journaalpost.Columns.Add("REK", GetType(System.Int32)).DefaultValue = 102611
        dt_journaalpost.Columns.Add("FACT", GetType(System.Int32)).DefaultValue = 44556677
        dt_journaalpost.Columns.Add("TEGREK", GetType(System.Int32)).DefaultValue = 28990 ' splitsingsrekening in demo-administratie.
        dt_journaalpost.Columns.Add("BTW", GetType(System.Int32)).DefaultValue = 0
        dt_journaalpost.Columns.Add("BEDRBOEK", GetType(System.Double)).DefaultValue = 10.4901
        dt_journaalpost.Columns.Add("BEDRBTW", GetType(System.Double)).DefaultValue = 0
        dt_journaalpost.Columns.Add("DAT", GetType(System.String)).DefaultValue = "28-11-2011"
        dt_journaalpost.Columns.Add("OPM", GetType(System.String)).DefaultValue = "Opmerking"
        dt_journaalpost.Columns.Add("OMSCHR", GetType(System.String)).DefaultValue = txtOmschr.Text
        dt_journaalpost.Columns.Add("BOEKSTUK", GetType(System.String)).DefaultValue = "1000"

        dt_journaalpost.Columns.Add("FORCE_DATBOEKSTUK", GetType(System.String)).DefaultValue = "J" ' in een uitsplitsing wordt datum en boekstuk altijd gelijk gehouden, tenzij hier expliciet FORCE_DATBOEKSTUK op J wordt gezet.

        ' dt_journaalpost.Columns.Add("URLDOC", GetType(System.String)).DefaultValue = "http://www.muis.nl/?urldoc=123456789"
        ' URLDOC is nog niet geimplementeerd.

        Dim dr_journaalpost = dt_journaalpost.NewRow : dt_journaalpost.Rows.Add(dr_journaalpost)

        dr_journaalpost = dt_journaalpost.NewRow
        dr_journaalpost("BEDRBOEK") = -8.6
        dr_journaalpost("REK") = 83090
        dr_journaalpost("TEGREK") = 28990
        dr_journaalpost("BEDRBTW") = "-1,81"
        dr_journaalpost("BTW") = 12
        dr_journaalpost("DAT") = "29-11-2011"
        dr_journaalpost("FACT") = 0
        dt_journaalpost.Rows.Add(dr_journaalpost)

        If chkdigdos.Checked Then
            Dim dt_digdos As DataTable = ds_journaalpost.Tables.Add
            dt_digdos.TableName = "DIGDOS"
            dt_digdos.Columns.Add("FILE", GetType(System.Byte()))
            Dim dr_digdos = dt_digdos.NewRow

            Dim dir_ori As String = Environment.CurrentDirectory
            ChDir(Environment.CurrentDirectory.Substring(0, Environment.CurrentDirectory.LastIndexOf("\")))
            ChDir(Environment.CurrentDirectory.Substring(0, Environment.CurrentDirectory.LastIndexOf("\")))
            dr_digdos("FILE") = System.IO.File.ReadAllBytes(System.IO.Path.Combine(Environment.CurrentDirectory, "voorbeeldbijlage.pdf"))
            ChDir(dir_ori)

            dt_digdos.Rows.Add(dr_digdos)
        End If

        Dim MessageId() As String = Nothing
        If Not ws1.CreateJournaalpost(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_journaalpost, MessageId, foutmelding) Then
            MsgBox("Journaalposten boeken mislukt: " + foutmelding)
        Else
            MsgBox("Journaalposten geboekt: " + MessageId.Length.ToString + " regels.")
        End If
    End Sub

    Private Sub btnPasJournaalpostAan_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPasJournaalpostAan.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
        If String.IsNullOrEmpty(txtPrimarykey.Text) Then MsgBox("Primarykey is leeg.") : Exit Sub

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_journaalpost As New DataSet
                Dim dt_journaalpost As DataTable = ds_journaalpost.Tables.Add
                dt_journaalpost.Columns.Add("OMSCHR", GetType(System.String)).DefaultValue = txtOmschr.Text

                Dim dr_journaalpost = dt_journaalpost.NewRow : dt_journaalpost.Rows.Add(dr_journaalpost)

                Dim MessageId() As String = Nothing
                If Not ws1.UpdateJournaalpost(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, txtPrimarykey.Text, ds_journaalpost, foutmelding) Then
                    MsgBox("Journaalpost aanpassen mislukt: " + foutmelding)
                Else
                    MsgBox("Journaalpost correct aangepast.")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim foutmelding As String = ""

                Dim ds_journaalpost As New DataSet
                Dim dt_journaalpost As DataTable = ds_journaalpost.Tables.Add
                dt_journaalpost.TableName = "BOE"
                dt_journaalpost.Columns.Add("OMSCHR", GetType(System.String)).DefaultValue = txtOmschr.Text
                Dim dr_journaalpost = dt_journaalpost.NewRow : dt_journaalpost.Rows.Add(dr_journaalpost)

                Dim sw As New IO.StringWriter
                ds_journaalpost.WriteXml(sw)
                Dim xml_journaalpost As String = sw.ToString

                Dim primarykey As String = txtPrimarykey.Text

                If Not ws1_xml.UpdateJournaalpost(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, primarykey, xml_journaalpost, foutmelding) Then
                    MsgBox("Journaalpost aanpassing mislukt: " + foutmelding)
                Else
                    MsgBox("Journaalpost aangepast.")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "UPDATEJOURNAALPOST") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                valuecollection.Add("PRIMARYKEY", txtPrimarykey.Text)

                Dim ds_journaalpost As New DataSet
                Dim dt_journaalpost As DataTable = ds_journaalpost.Tables.Add
                dt_journaalpost.TableName = "BOE"
                dt_journaalpost.Columns.Add("OMSCHR", GetType(System.String)).DefaultValue = txtOmschr.Text
                Dim dr_journaalpost = dt_journaalpost.NewRow : dt_journaalpost.Rows.Add(dr_journaalpost)

                Dim sw As New IO.StringWriter
                ds_journaalpost.WriteXml(sw)
                Dim xml_journaalpost As String = sw.ToString

                valuecollection.Add("JOURNAALPOST", xml_journaalpost)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Journaalpost aanpassing mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                MsgBox("Journaalpost aangepast.")
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If Not String.IsNullOrEmpty(txtSessionId.Text) Then Logout(txtSessionId.Text)
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Timer1.Start()
        lblKeepSession.Text = ""

        txtPartnerKey.Text = partnerkey.ToString
        txtOmgevingsCode.Text = omgevingscode_demoadministratie.ToString
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        KeepSession()
    End Sub

    Private Sub btnKeepSession_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnKeepSession.Click
        KeepSession()
    End Sub

    Private Sub btnUpdateStamTabelRecord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUpdateStamTabelRecord.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
        If String.IsNullOrEmpty(txtDebNr.Text) Then MsgBox("NR is leeg.") : Exit Sub

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "SELECTION"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                dt_selection.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selection.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "="
                dt_selection.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtDebNr.Text
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "DATA"
                dt_data.Columns.Add("NAAM", GetType(System.String)).DefaultValue = txtDebNaam.Text
                Dim dr_mutation = dt_data.NewRow : dt_data.Rows.Add(dr_mutation)

                If Not ws1.UpdateStamtabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_mutatie, foutmelding) Then
                    MsgBox("Record aanpassen mislukt: " + foutmelding)
                Else
                    MsgBox("Record correct aangepast.")
                End If
            Case "XML"
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
                If String.IsNullOrEmpty(txtDebNr.Text) Then MsgBox("NR is leeg.") : Exit Sub

                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "SELECTION"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                dt_selection.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selection.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "="
                dt_selection.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtDebNr.Text
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "DATA"
                dt_data.Columns.Add("NAAM", GetType(System.String)).DefaultValue = txtDebNaam.Text
                dt_data.Columns.Add("BTWNR", GetType(System.String)).DefaultValue = ""
                dt_data.Columns.Add("BTWPL", GetType(System.String)).DefaultValue = "B"
                Dim dr_mutation = dt_data.NewRow : dt_data.Rows.Add(dr_mutation)

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim mutatie As String = sw.ToString

                mutatie = "<NewDataSet><SELECTION><TABLE>DEB</TABLE><WHEREFIELDS>NR</WHEREFIELDS><WHEREOPERATORS>=</WHEREOPERATORS><WHEREVALUES>15274</WHEREVALUES></SELECTION>"
                mutatie += "<DATA>"
                mutatie += "<NR>15274</NR>"
                mutatie += "<NAAM>Mooi Creatie</NAAM>"
                mutatie += "<NAAM2>Bas Bosscher</NAAM2>"
                mutatie += "<ZKSL>MOO</ZKSL>"
                mutatie += "<STRAAT>Veldkampweg</STRAAT>"
                mutatie += "<HNR>5</HNR>"
                mutatie += "<HNRTV/>"
                mutatie += "<POSTCD>7731 HL</POSTCD>"
                mutatie += "<PLAATS>OMMEN</PLAATS>"
                mutatie += "<LAND>NL</LAND>"
                mutatie += "<TAAL>NED</TAAL>"
                mutatie += "<TEL>0529-463363</TEL>"
                mutatie += "<FAX/>"
                mutatie += "<MOBIEL>06-34348702</MOBIEL>"
                mutatie += "<EMAIL>bas@mooicreatie.nl</EMAIL>"
                mutatie += "<HOMEPAGE>www.mooicreatie.nl</HOMEPAGE>"
                mutatie += "<BTWNR/>"
                mutatie += "<BTWPL>B</BTWPL>"
                mutatie += "<KVKNR/>"
                mutatie += "<KRLIM>0,00</KRLIM>"
                mutatie += "<BLOK>N</BLOK>"
                mutatie += "<BETCOND>10</BETCOND>"
                mutatie += "<AANM>J</AANM>"
                mutatie += "<AANMAFDRUK>E</AANMAFDRUK>"
                mutatie += "<OPM/>"
                mutatie += "</DATA></NewDataSet>"

                mutatie = "<NewDataSet><SELECTION><TABLE>DEB</TABLE><WHEREFIELDS>NR</WHEREFIELDS><WHEREOPERATORS>=</WHEREOPERATORS><WHEREVALUES>11003</WHEREVALUES></SELECTION><DATA><NR>11003</NR><NAAM>Agriprom agrarische producten</NAAM><NAAM2>Tristan Staal</NAAM2><ZKSL>AGRI</ZKSL><STRAAT>Postbus</STRAAT><HNR>44</HNR><HNRTV/><POSTCD>7710 AA</POSTCD><PLAATS>NIEUWLEUSEN</PLAATS><LAND/><TAAL/><TEL>0529-455320</TEL><FAX>0529-455315</FAX><MOBIEL/><EMAIL>info@agriprom.nl</EMAIL><HOMEPAGE>www.agriprom.nl</HOMEPAGE><BTWNR/><BTWPL>B</BTWPL><KVKNR/><KRLIM>0,00</KRLIM><BLOK>N</BLOK><BETCOND/><AANM>J</AANM><AANMAFDRUK>E</AANMAFDRUK><OPM/></DATA></NewDataSet>"


                If Not ws1_xml.UpdateStamtabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, mutatie, foutmelding) Then
                    MsgBox("Record aanpassen mislukt: " + foutmelding)
                Else
                    MsgBox("Record correct aangepast.")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "UPDATESTAMTABELRECORD") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "SELECTION"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                dt_selection.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selection.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "="
                dt_selection.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtDebNr.Text
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "DATA"
                dt_data.Columns.Add("NAAM", GetType(System.String)).DefaultValue = txtDebNaam.Text
                Dim dr_mutation = dt_data.NewRow : dt_data.Rows.Add(dr_mutation)

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim mutatie As String = sw.ToString

                valuecollection.Add("MUTATIE", mutatie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Record aanpassen mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                MsgBox("Record correct aangepast.")
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub TabControl1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles TabControl1.Click
        If TabControl1.SelectedIndex > 0 Then
            If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("U moet eerst inloggen.") : TabControl1.SelectedIndex = 0
        End If
    End Sub

    Private Sub btnDeleteJournaalpost_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDeleteJournaalpost.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
        If String.IsNullOrEmpty(txtPrimarykey.Text) Then MsgBox("Primarykey is leeg.") : Exit Sub

        Dim foutmelding As String = ""

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                If Not ws1.DeleteJournaalpost(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, txtPrimarykey.Text, foutmelding) Then
                    MsgBox("Journaalpost verwijderen mislukt: " + foutmelding)
                Else
                    MsgBox("Journaalpost verwijderen gelukt.")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml

                Dim primarykey As String = txtPrimarykey.Text

                If Not ws1_xml.DeleteJournaalpost(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, primarykey, foutmelding) Then
                    MsgBox("Journaalpost verwijdering mislukt: " + foutmelding)
                Else
                    MsgBox("Journaalpost verwijderd.")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "DELETEJOURNAALPOST") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                valuecollection.Add("PRIMARYKEY", txtPrimarykey.Text)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Journaalpost verwijdering mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                MsgBox("Journaalpost verwijderd.")
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub btnDeleteStamTabelRecord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDeleteStamTabelRecord.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
        If String.IsNullOrEmpty(txtDebNr.Text) Then MsgBox("Debiteurnummer is niet ingevuld.") : Exit Sub

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "SELECTION"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                dt_selection.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selection.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "="
                dt_selection.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtDebNr.Text
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                If Not ws1.DeleteStamtabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_mutatie, foutmelding) Then
                    MsgBox("Debiteur verwijderen mislukt: " + foutmelding)
                Else
                    MsgBox("Debiteur verwijderen gelukt.")
                End If
            Case "XML"
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
                If String.IsNullOrEmpty(txtDebNr.Text) Then MsgBox("Debiteurnummer is niet ingevuld.") : Exit Sub

                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "SELECTION"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                dt_selection.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selection.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "="
                dt_selection.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtDebNr.Text
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim mutatie As String = sw.ToString

                If Not ws1_xml.DeleteStamtabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, mutatie, foutmelding) Then
                    MsgBox("Debiteur verwijderen mislukt: " + foutmelding)
                Else
                    MsgBox("Debiteur verwijderen gelukt.")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "DELETESTAMTABELRECORD") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "SELECTION"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                dt_selection.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selection.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "="
                dt_selection.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtDebNr.Text
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim mutatie As String = sw.ToString

                valuecollection.Add("MUTATIE", mutatie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Debiteur verwijderen mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                MsgBox("Debiteur verwijderen gelukt.")
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub btnCreateNewDeb_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateNewDeb.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "METADATA"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "DATA"
                dt_data.Columns.Add("ZKSL", GetType(System.String)).DefaultValue = txtZKSLNieuw.Text

                Dim dr_data = dt_data.NewRow : dt_data.Rows.Add(dr_data)

                Dim MessageId() As String = Nothing
                If Not ws1.CreateStamTabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_mutatie, txtNrNieuw.Text, foutmelding) Then
                    MsgBox("debiteur aangemaakt mislukt: " + foutmelding)
                Else
                    MsgBox("debiteur aangemaakt, deb.nr: " + txtNrNieuw.Text)
                    txtDebNr.Text = txtNrNieuw.Text
                End If
            Case "XML"
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "METADATA"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "DATA"
                dt_data.Columns.Add("ZKSL", GetType(System.String)).DefaultValue = txtZKSLNieuw.Text

                Dim dr_data = dt_data.NewRow : dt_data.Rows.Add(dr_data)

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim stamtabel As String = sw.ToString

                ' voorbeeld: "<NewDataSet>   <METADATA>     <TABLE>DEB</TABLE>   </METADATA>   <DATA>     <ZKSL>naam debiteur</ZKSL>   </DATA> </NewDataSet>"

                Dim MessageId() As String = Nothing
                If Not ws1_xml.CreateStamTabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, stamtabel, txtNrNieuw.Text, foutmelding) Then
                    MsgBox("debiteur aangemaakt mislukt: " + foutmelding)
                Else
                    MsgBox("debiteur aangemaakt, deb.nr: " + txtNrNieuw.Text)
                    txtDebNr.Text = txtNrNieuw.Text
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "CREATESTAMTABELRECORD") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "METADATA"
                dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "DATA"
                dt_data.Columns.Add("ZKSL", GetType(System.String)).DefaultValue = txtZKSLNieuw.Text

                Dim dr_data = dt_data.NewRow : dt_data.Rows.Add(dr_data)

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim stamtabel As String = sw.ToString

                valuecollection.Add("STAMTABEL", stamtabel)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Debiteur aangemaakt mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                txtNrNieuw.Text = ds_return.Tables("TABEL").Rows(0)("PRIMARYKEY")
                                MsgBox("Debiteur aangemaakt, deb.nr: " + txtNrNieuw.Text)
                                txtDebNr.Text = txtNrNieuw.Text
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "CREOPP"
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "SALDO" + TAB + "DATVERV" + TAB + "DATLSTBET"
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "CRE" + TAB + "FACT"
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "=" + TAB + "="
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtCreNrInfo.Text + TAB + txtFactNrInfo.Text
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "FACT"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 1
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridView4.Columns.Clear()
                    DataGridView4.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"

            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable

                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "CREOPP"
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "SALDO" + TAB + "DATVERV" + TAB + "DATLSTBET"
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "CRE" + TAB + "FACT"
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "=" + TAB + "="
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtCreNrInfo.Text + TAB + txtFactNrInfo.Text
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "FACT"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 1
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Keepsession mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                Dim ds_records As New DataSet
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridView4.Columns.Clear()
                                DataGridView4.DataSource = ds_records.Tables("DATA")
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
        If String.IsNullOrEmpty(txtOphJr.Text) Then MsgBox("Jaar is leeg.") : Exit Sub
        If String.IsNullOrEmpty(txtOphDagb.Text) Then MsgBox("Dagboek is leeg.") : Exit Sub
        If String.IsNullOrEmpty(txtOphFactNr.Text) Then MsgBox("Intern factuurnummer is leeg.") : Exit Sub

        Dim ws1 As New ws1.ws1
        Dim foutmelding As String = ""
        Dim ds_records As New DataSet

        Dim ds_selectie As New DataSet
        Dim dt_selectie As DataTable = ds_selectie.Tables.Add
        dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "BOE"
        dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "DAGB" + TAB + "JR" + TAB + "PN" + TAB + "RG" + TAB + "BEDRBOEK"
        dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "JR" + TAB + "DAGB" + TAB + "FACT"

        ' Tbv performance wordt op de tabel BOE alleen = geaccepteerd.
        dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "=" + TAB + "=" + TAB + "="
        dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = txtOphJr.Text + TAB + txtOphDagb.Text + TAB + txtOphFactNr.Text
        dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "RG"
        dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
        dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 1
        dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

        Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

        If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
            MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
        Else
            DataGridView6.Columns.Clear()
            DataGridView6.DataSource = ds_records.Tables("DATA")
        End If
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        Dim ds_selectie As New DataSet
        Dim dt_selectie As DataTable = ds_selectie.Tables.Add
        dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "PERIODESALDI"
        dt_selectie.Columns.Add("JRVANAF", GetType(System.String)).DefaultValue = txtJrVanaf.Text
        dt_selectie.Columns.Add("JRTM", GetType(System.String)).DefaultValue = txtJrTm.Text
        Dim aInTm As String = "IN"
        If checktm.Checked Then aInTm = "TM"
        dt_selectie.Columns.Add("INTM", GetType(System.String)).DefaultValue = aInTm
        dt_selectie.Columns.Add("PN", GetType(System.String)).DefaultValue = txtPn.Text
        dt_selectie.Columns.Add("VALUTA", GetType(System.String)).DefaultValue = "EUR"

        Dim dr_selectie As DataRow
        dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

        Dim ds_records As New DataSet
        Dim foutmelding As String = ""
        Dim ws1 As New ws1.ws1
        If Not ws1.GetAdmInfo(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
            MsgBox("GetAdmInfo mislukt: " + foutmelding)
        Else
            datagrid_proefsaldi.Columns.Clear()
            datagrid_proefsaldi.DataSource = ds_records.Tables("PERIODESALDI")
        End If
    End Sub

    Public Sub New()

        ' This call is required by the Windows Form Designer.
        InitializeComponent()

        combometh.SelectedItem = "API"
        ComboBoxArtCategorie.SelectedIndex = 0
        txtPartnerKey.Text = partnerkey
        txtOmgevingsCode.Text = omgevingscode_demoadministratie

        ' Add any initialization after the InitializeComponent() call.

    End Sub

    Private Sub btnMeerdereJournaalpostenAPI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMeerdereJournaalpostenAPI.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub
        txtPrimarykey.Text = "" : txtOmschr.Enabled = False : btnPasJournaalpostAan.Enabled = False : btnDeleteJournaalpost.Enabled = False

        Select Case combometh.SelectedItem
            Case "SOAP"

            Case "XML"

            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "CREATEJOURNAALPOST") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim ds_journaalpost As New DataSet
                Dim dt_journaalpost As DataTable = ds_journaalpost.Tables.Add
                dt_journaalpost.TableName = "BOE"
                dt_journaalpost.Columns.Add("JR", GetType(System.Int32)).DefaultValue = Now.Year
                dt_journaalpost.Columns.Add("PN", GetType(System.Int32)).DefaultValue = Now.Month
                dt_journaalpost.Columns.Add("DAGB", GetType(System.Int32)).DefaultValue = 70
                dt_journaalpost.Columns.Add("REK", GetType(System.Int32)).DefaultValue = 100918
                dt_journaalpost.Columns.Add("TEGREK", GetType(System.Int32)).DefaultValue = 28990
                dt_journaalpost.Columns.Add("FACT", GetType(System.Int32)).DefaultValue = 68086
                dt_journaalpost.Columns.Add("BTW", GetType(System.Int32)).DefaultValue = 0
                dt_journaalpost.Columns.Add("BEDRBOEK", GetType(System.Double)).DefaultValue = "158.49"
                dt_journaalpost.Columns.Add("BEDRBTW", GetType(System.Double)).DefaultValue = 0
                dt_journaalpost.Columns.Add("DAT", GetType(System.String)).DefaultValue = "07-11-" + Now.Year.ToString
                dt_journaalpost.Columns.Add("OPM", GetType(System.String)).DefaultValue = ""
                dt_journaalpost.Columns.Add("OMSCHR", GetType(System.String)).DefaultValue = "adv. Lydia Panman-Bakker"
                dt_journaalpost.Columns.Add("BOEKSTUK", GetType(System.String)).DefaultValue = "68086"
                dt_journaalpost.Columns.Add("KPL", GetType(System.Int32)).DefaultValue = 0
                dt_journaalpost.Columns.Add("KDR", GetType(System.Int32)).DefaultValue = 0
                Dim dr_journaalpost = dt_journaalpost.NewRow : dt_journaalpost.Rows.Add(dr_journaalpost)

                dr_journaalpost = dt_journaalpost.NewRow
                dr_journaalpost("BEDRBOEK") = "-130.98"
                dr_journaalpost("REK") = 80010
                dr_journaalpost("TEGREK") = 28990
                dr_journaalpost("BEDRBTW") = "-27.51"
                dr_journaalpost("BTW") = 12
                dr_journaalpost("OMSCHR") = "adv. Lydia Panman-Bakker"
                dt_journaalpost.Rows.Add(dr_journaalpost)

                Dim MessageId() As String = Nothing

                Dim sw As New IO.StringWriter
                ds_journaalpost.WriteXml(sw)
                Dim xml_journaalpost As String = sw.ToString

                valuecollection.Add("JOURNAALPOST", xml_journaalpost)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Journaalpost mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ReDim MessageId(0)
                                For Each dr As DataRow In ds_return.Tables("PRIMARYKEYS").Rows
                                    MessageId(MessageId.Length - 1) = dr("PRIMARYKEY")
                                Next
                                MsgBox("Journaalpost geboekt: " + MessageId.Length.ToString + " regel.")
                                txtPrimarykey.Text = MessageId(0).ToString

                                ds_journaalpost = New DataSet
                                ds_journaalpost.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(xml_journaalpost)))
                                Dim dt_journaalpost_return As DataTable = ds_return.Tables("BOE")

                                txtFactNr.Text = dt_journaalpost_return.Rows(0)("FACT")
                                txtOmschr.Enabled = True : btnPasJournaalpostAan.Enabled = True : btnDeleteJournaalpost.Enabled = True
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub Button10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button10.Click
        ' ophalen betalingscondities.
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim ws1 As New ws1.ws1
        Dim foutmelding As String = ""
        Dim ds_records As New DataSet

        Dim ds_selectie As New DataSet
        Dim dt_selectie As DataTable = ds_selectie.Tables.Add
        dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "BETCOND"
        dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "NR" + TAB + "ZKSL" + TAB + "OPM" + TAB + "VERVDGN"
        dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
        dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = ">"
        dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = "0"
        dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
        dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
        dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
        dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

        Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

        If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
            MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
        Else
            DataGridView1.Columns.Clear()
            DataGridView1.DataSource = ds_records.Tables("DATA")
            Label4.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
        End If
    End Sub

    Private Sub btnGetStamtabelRecords_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetStamtabelRecords.Click
        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "GRB"
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "NR" + TAB + "ZKSL" + TAB + "OMSCHR"
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = ">"
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = "1000"
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 20
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridView1.Columns.Clear()
                    DataGridView1.DataSource = ds_records.Tables("DATA")
                    Label4.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "GRB"
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "NR" + TAB + "ZKSL" + TAB + "OMSCHR"
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = ">"
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = "1000"
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 20
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    Dim ds_records As New DataSet
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridView1.Columns.Clear()
                    DataGridView1.DataSource = ds_records.Tables("DATA")
                    Label4.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "GRB"
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "NR" + TAB + "ZKSL" + TAB + "OMSCHR"
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = ">"
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = "1000"
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 20
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Keepsession mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                Dim ds_records As New DataSet
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridView1.Columns.Clear()
                                DataGridView1.DataSource = ds_records.Tables("DATA")
                                Label4.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub Button1_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim foutmelding As String = ""

        Dim ws1 As New ws1.ws1

        Dim ds_records As New DataSet

        Dim ds_selectie As New DataSet
        Dim dt_selectie As DataTable = ds_selectie.Tables.Add
        dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "PERIODEDATUMS"
        dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = Now.Year

        Dim dr_selectie As DataRow
        dr_selectie = dt_selectie.NewRow : dr_selectie("TABLE") = "PERIODEDATUMS" : dr_selectie("SELECTFIELDS") = Now.Year : dt_selectie.Rows.Add(dr_selectie)
        dr_selectie = dt_selectie.NewRow : dr_selectie("TABLE") = "BASALG" : dr_selectie("SELECTFIELDS") = "NAAM" + Chr(9) + "BTWNR" : dt_selectie.Rows.Add(dr_selectie)
        dr_selectie = dt_selectie.NewRow : dr_selectie("TABLE") = "PERIODEINFO" : dt_selectie.Rows.Add(dr_selectie)

        If Not ws1.GetAdmInfo(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
            MsgBox("GetAdmInfo mislukt: " + foutmelding)
        Else
            DataGridView2.Columns.Clear()
            DataGridView2.DataSource = ds_records.Tables("BASALG")
            Label4.Text = "Aantal records: " + ds_records.Tables("BASALG").Rows.Count.ToString + "."
            DataGridView3.Columns.Clear()
            DataGridView3.DataSource = ds_records.Tables("PERIODEDATUMS")
            DataGridView5.Columns.Clear()
            DataGridView5.DataSource = ds_records.Tables("PERIODEINFO")
        End If
    End Sub

    Private Sub Button4_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click, Button13.Click
        ' ophalen crediteuren.
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim ws1 As New ws1.ws1
        Dim foutmelding As String = ""
        Dim ds_records As New DataSet

        Dim ds_selectie As New DataSet
        Dim dt_selectie As DataTable = ds_selectie.Tables.Add
        dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "CRE"
        dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "NR" + TAB + "ZKSL" + TAB + "NAAM" + TAB + "PLAATS" + TAB + "BTWNR" + TAB + "BNKREK" + TAB + "GIRO"
        dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NAAM;PLAATS"
        dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = "LIKE"
        dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = "%a%"
        dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
        dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
        dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 20
        dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

        Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

        If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
            MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
        Else
            DataGridView1.Columns.Clear()
            DataGridView1.DataSource = ds_records.Tables("DATA")
            Label4.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
        End If
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        DataGridViewArt.Columns.Clear()

        Dim aCategorie As String = ComboBoxArtCategorie.SelectedItem
        Dim aWhereFields As String = "CATEGORIE"
        Dim aWhereOperators As String = "="
        Dim aWhereValues As String = "A"

        Dim aSelectFields As String = "NR" + TAB + "ZKSL" + TAB + "OMSCHR" + TAB + "AFBEELDINGART" + TAB + "VASTEPRS"
        Dim aMaxResult As Integer = 0
        Dim aGetVrd As String = "J"

        Select Case aCategorie
            Case "Artikelen"
                If Not String.IsNullOrEmpty(aWhereFields) Then aWhereFields += TAB : aWhereOperators += TAB : aWhereValues += TAB
                aWhereFields += "VRDREG" + TAB + "BLOKWEBSHOP" : aWhereOperators += "=" + TAB + "=" : aWhereValues += "J" + TAB + "N"
            Case "Werksoorten"
                aWhereValues = "W"
                aGetVrd = "N"
            Case Else
                aWhereFields = "" : aWhereOperators = "" : aWhereValues = ""
        End Select
        If Not String.IsNullOrEmpty(aWhereFields) Then aWhereFields += TAB : aWhereOperators += TAB : aWhereValues += TAB
        aWhereFields += "NR" : aWhereOperators += ">" : aWhereValues += "0"

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "ART"
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                If Not String.IsNullOrEmpty(aGetVrd) Then dt_selectie.Columns.Add("GETVRD", GetType(System.String)).DefaultValue = aGetVrd

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "ART"
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                If Not String.IsNullOrEmpty(aGetVrd) Then dt_selectie.Columns.Add("GETVRD", GetType(System.String)).DefaultValue = aGetVrd

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "ART"
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 2
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                If Not String.IsNullOrEmpty(aGetVrd) Then dt_selectie.Columns.Add("GETVRD", GetType(System.String)).DefaultValue = aGetVrd

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click
        DataGridViewArt.Columns.Clear()

        Dim aCategorie As String = ComboBoxArtCategorie.SelectedItem
        Dim aWhereFields As String = "NR"
        Dim aWhereOperators As String = ">"
        Dim aWhereValues As String = "0"

        Dim aTable As String = "ARTGRP"
        Dim aSelectFields As String = "NR" + TAB + "ZKSL"

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    Dim ds_records As New DataSet
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Keepsession mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                Dim ds_records As New DataSet
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button8.Click
        Dim aArt As String = DataGridViewArt.Item("NR", DataGridViewArt.CurrentRow.Index).Value

        PictureBox1.Visible = False

        Dim aWhereFields As String = "ART"
        Dim aWhereOperators As String = "="
        Dim aWhereValues As String = aArt

        Dim aTable As String = "ARTAFB"
        Dim aSelectFields As String = "ZKSL" + TAB + "STD" + TAB + "ART"
        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "ZKSL"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "ZKSL"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "ZKSL"
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelRecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select

        Label29.Text = "Aantal afbeeldingen: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT")
        If CLng(ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT")) > 0 Then
            If ds_records.Tables("DATA").Rows.Count > 0 Then
                PictureBox1.Visible = True
                Dim aImgByteArray() As Byte = Convert.FromBase64String(ds_records.Tables("DATA").Rows(0)("AFBEELDING").ToString)
                Dim aMemstream As System.IO.MemoryStream = New System.IO.MemoryStream(aImgByteArray)
                PictureBox1.Image = System.Drawing.Image.FromStream(aMemstream)
                ' System.IO.File.WriteAllBytes("c:\windows\temp\artafb_byte.jpg", aImgByteArray)
            End If
        End If
    End Sub

    Private Sub CheckBox1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox1.CheckedChanged
        DateTimePicker1.Enabled = CheckBox1.Checked
    End Sub

    Private Sub Button9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button9.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "ARTMAG"
        Dim aSelectFields As String = "ART" + TAB + "MAGAZIJN" + TAB + "VRDTECH" + TAB + "VRDVRIJVERK"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "ART"

        Dim aWhereFields As String = ""
        Dim aWhereOperators As String = ""
        Dim aWhereValues As String = ""

        aWhereFields += "ART" : aWhereOperators += ">=" : aWhereValues += "00011-009"
        aWhereFields += TAB : aWhereOperators += TAB : aWhereValues += TAB
        aWhereFields += "ART" : aWhereOperators += "<=" : aWhereValues += "00014-017"

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 2
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using

                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub Button11_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button11.Click
        DataGridViewArt.Columns.Clear()

        PictureBox1.Visible = False

        Dim aWhereFields As String = "ART"
        Dim aWhereOperators As String = ">"
        Dim aWhereValues As String = "0"

        Dim aTable As String = "ARTAFB"
        Dim aSelectFields As String = "ART" + TAB + "STD" + TAB + "ZKSL"
        Dim aOrderBy As String = "ART"

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                dt_selectie.Columns.Add("ART.BLOKWEBSHOP", GetType(System.String)).DefaultValue = "N"

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                dt_selectie.Columns.Add("ART.BLOKWEBSHOP", GetType(System.String)).DefaultValue = "N"

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                dt_selectie.Columns.Add("ART.BLOKWEBSHOP", GetType(System.String)).DefaultValue = "N"

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Keepsession mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception
                    MsgBox(ex.ToString)
                End Try
        End Select

        Label29.Text = "Aantal afbeeldingen: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT")
        If CLng(ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT")) > 0 Then
            If ds_records.Tables("DATA").Rows.Count > 0 Then
                PictureBox1.Visible = True
                Dim aImgByteArray() As Byte = Convert.FromBase64String(ds_records.Tables("DATA").Rows(0)("AFBEELDING").ToString)
                Dim aMemstream As System.IO.MemoryStream = New System.IO.MemoryStream(aImgByteArray)
                PictureBox1.Image = System.Drawing.Image.FromStream(aMemstream)
                ' System.IO.File.WriteAllBytes("c:\windows\temp\artafb_byte.jpg", aImgByteArray)
            End If
        End If
    End Sub

    Private Sub Button12_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button12.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "ARTTAAL"
        Dim aSelectFields As String = "ART" + TAB + "OMSCHR"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "ART"

        Dim aWhereFields As String = ""
        Dim aWhereOperators As String = ""
        Dim aWhereValues As String = ""

        aWhereFields += "ART" : aWhereOperators += ">=" : aWhereValues += "00011-009"
        aWhereFields += TAB : aWhereOperators += TAB : aWhereValues += TAB
        aWhereFields += "ART" : aWhereOperators += "<=" : aWhereValues += "00014-017"

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 2
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using

                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub ButtonVerkord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonVerkord.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim foutmelding As String = ""
        Dim ORDNR As Integer = 0
        txtOrdNr.Text = ""

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ds_verkooporder As New DataSet
                Dim dt_verkooporder As DataTable = ds_verkooporder.Tables.Add
                dt_verkooporder.TableName = "ORDKOP"
                dt_verkooporder.Columns.Add("DEB", GetType(System.Int32)).DefaultValue = 10000
                dt_verkooporder.Columns.Add("DAT", GetType(System.String)).DefaultValue = FormatDateTime(Now, DateFormat.ShortDate)
                dt_verkooporder.Columns.Add("ORDSRT", GetType(System.String)).DefaultValue = "op rekening"
                Dim dr_verkooporder = dt_verkooporder.NewRow : dt_verkooporder.Rows.Add(dr_verkooporder)

                Dim dt_verkooporderregel As DataTable = ds_verkooporder.Tables.Add
                dt_verkooporderregel.TableName = "ORDRG"
                dt_verkooporderregel.Columns.Add("ART", GetType(System.String)).DefaultValue = "9001"
                dt_verkooporderregel.Columns.Add("AANT", GetType(System.Double)).DefaultValue = 10
                dt_verkooporderregel.Columns.Add("PRS", GetType(System.Double)).DefaultValue = "50"
                ' .DefaultValue = 100.25

                Dim dr_orderregel = dt_verkooporderregel.NewRow : dt_verkooporderregel.Rows.Add(dr_orderregel)

                'dr_orderregel = dt_verkooporderregel.NewRow
                'dr_orderregel("ART") = "9000"
                'dr_orderregel("AANT") = 1
                'dr_orderregel("PRS") = "100"
                'dt_verkooporderregel.Rows.Add(dr_orderregel)

                Dim ws1 As New ws1.ws1

                If Not ws1.CreateVerkoopOrder(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_verkooporder, ORDNR, foutmelding) Then
                    MsgBox("order aanmaken mislukt: " + foutmelding)
                Else
                    txtOrdNr.Text = ORDNR
                    MsgBox("order aangemaakt, ord.nr: " + txtOrdNr.Text)
                End If
            Case "XML"
                
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "CREATEVERKOOPORDER") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim ds_mutatie As New DataSet
                Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "ORDKOP"
                dt_selection.Columns.Add("DEB", GetType(System.Int32)).DefaultValue = 10000
                dt_selection.Columns.Add("DAT", GetType(System.String)).DefaultValue = FormatDateTime(Now, DateFormat.ShortDate)
                dt_selection.Columns.Add("ORDSRT", GetType(System.String)).DefaultValue = "standaard"
                Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)

                Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "ORDRG"
                dt_data.Columns.Add("ART", GetType(System.String)).DefaultValue = "9000"
                dt_data.Columns.Add("AANT", GetType(System.Double)).DefaultValue = 10
                dt_data.Columns.Add("PRS", GetType(System.Double)).DefaultValue = 100.25
                dt_data.Columns.Add("PERCKORT", GetType(System.Double)).DefaultValue = 10
                dt_data.Columns.Add("DATLEV", GetType(System.String)).DefaultValue = "01-01-2015"
                dt_data.Columns.Add("PERCKORTKORT", GetType(System.Double)).DefaultValue = 2.34
                dt_data.Columns.Add("OMSCHR", GetType(System.String)).DefaultValue = ""
                dt_data.Columns.Add("OPMINT", GetType(System.String)).DefaultValue = "Aangepaste &#39 interne opmerking"
                dt_data.Columns.Add("OPMEXT", GetType(System.String)).DefaultValue = "Aangepaste externe opmerking"

                Dim dr_data = dt_data.NewRow : dt_data.Rows.Add(dr_data)

                If chkdigdos.Checked Then
                    Dim dt_digdos As DataTable = ds_mutatie.Tables.Add
                    dt_digdos.TableName = "DIGDOS"
                    dt_digdos.Columns.Add("FILE", GetType(System.Byte()))
                    Dim dr_digdos = dt_digdos.NewRow

                    Dim dir_ori As String = Environment.CurrentDirectory
                    ChDir(Environment.CurrentDirectory.Substring(0, Environment.CurrentDirectory.LastIndexOf("\")))
                    ChDir(Environment.CurrentDirectory.Substring(0, Environment.CurrentDirectory.LastIndexOf("\")))
                    dr_digdos("FILE") = System.IO.File.ReadAllBytes(System.IO.Path.Combine(Environment.CurrentDirectory, "voorbeeldbijlage.pdf"))
                    ChDir(dir_ori)

                    dt_digdos.Rows.Add(dr_digdos)
                End If

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim verkooporder As String = sw.ToString

                valuecollection.Add("VERKOOPORDER", verkooporder)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Order aanmaken mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                txtOrdNr.Text = ds_return.Tables("ORDKOP").Rows(0)("NR")
                                MsgBox("Order aangemaakt, ord.nr: " + txtOrdNr.Text)
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub btnPrijs_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrijs.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "PRS"
        Dim aSelectFields As String = "PRSLST" + TAB + "ART" + TAB + "PRS" + TAB + "PERCKORT" + TAB + "DEB" + TAB + "PRSPER" + TAB + "PRSPER_DATVAN" + TAB + "PRSPER_DATTM"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "PRSPER_DATTM:D"

        Dim aWhereFields As String = ""
        Dim aWhereOperators As String = ""
        Dim aWhereValues As String = ""

        'aWhereFields += "NR"
        'aWhereOperators += ">"
        'aWhereValues += "0"

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using

                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub btnPrijslst_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrijslst.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "PRSLST"
        Dim aSelectFields As String = "ZKSL" + TAB + "PRSLST" + TAB + "OMSCHR" + TAB + "BLOK"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "ZKSL"

        Dim aWhereFields As String = ""
        Dim aWhereOperators As String = ""
        Dim aWhereValues As String = ""

        aWhereFields += "BLOK"
        aWhereOperators += "="
        aWhereValues += "N"

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 2
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using

                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub btnCnt_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCnt.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "CNT"
        Dim aSelectFields As String = "NR" + TAB + "ZKSL" + TAB + "EMAIL" + TAB + "DEB" + TAB + "CRE" + TAB + "BLOK"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "ZKSL"

        Dim aWhereFields As String = ""
        Dim aWhereOperators As String = ""
        Dim aWhereValues As String = ""

        aWhereFields += "BLOK"
        aWhereOperators += "="
        aWhereValues += "N"

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 2
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub Button14_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button14.Click
        ' ophalen crediteuren.
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim ws1 As New ws1.ws1
        Dim foutmelding As String = ""
        Dim ds_records As New DataSet

        Dim ds_selectie As New DataSet
        Dim dt_selectie As DataTable = ds_selectie.Tables.Add
        dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "DEB"
        dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "NR" + TAB + "ZKSL" + TAB + "BTWNR" + TAB + "BNKREK" + TAB + "GIRO" + TAB + "GEBRSTAFFEL"
        dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = "NR"
        dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = ">"
        dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = "0"
        dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "NR"
        dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
        dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 2000
        dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

        Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

        If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
            MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
        Else
            DataGridView1.Columns.Clear()
            DataGridView1.DataSource = ds_records.Tables("DATA")
            Label4.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
        End If
    End Sub

    Private Sub Button15_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button15.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "INKRG"
        Dim aSelectFields As String = "ART" + TAB + "DATLEV" + TAB + "AANT" + TAB + "TOTONTVANGEN" + TAB + "DATLEVBEVESTIGD"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "DATLEV"

        Dim aWhereFields As String = "&TOTONTVANGEN" ' + TAB + "DATLEV"
        Dim aWhereOperators As String = "<" ' + TAB + ">"
        Dim aWhereValues As String = "AANT" '  + TAB + FormatDateTime(Now, DateFormat.ShortDate)

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 500
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 2

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub Button16_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button16.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "ARTLNK"
        Dim aSelectFields As String = "ART" + TAB + "EXTVERW" + TAB + "OMSCHR" + TAB + "TAAL"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "ART"

        Dim aWhereFields As String = "ART"
        Dim aWhereOperators As String = ">"
        Dim aWhereValues As String = "0"


        aTable = "ARTTAG" : aSelectFields = "ART" + TAB + "TAAL" + TAB + "TAG" : aWhereFields = "" : aWhereOperators = "" : aWhereValues = "" : aOrderBy = "ART"


        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 10
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 240
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub Button17_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button17.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "ARTMAG"
        Dim aSelectFields As String = "ART" + TAB + "MAGAZIJN" + TAB + "VRDTECH" + TAB + "VRDVRIJVERK" + TAB + "VRDECON" + TAB + "VRDBESTELD"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "ART"

        Dim aWhereFields As String = ""
        Dim aWhereOperators As String = ""
        Dim aWhereValues As String = ""

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                dt_selectie.Columns.Add("ART.BLOKWEBSHOP", GetType(System.String)).DefaultValue = "N"

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                dt_selectie.Columns.Add("ART.BLOKWEBSHOP", GetType(System.String)).DefaultValue = "N"

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 500
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1
                If Not String.IsNullOrEmpty(aMutDateVa) Then dt_selectie.Columns.Add("MUTDATE_VA", GetType(System.DateTime)).DefaultValue = aMutDateVa
                dt_selectie.Columns.Add("ART.BLOKWEBSHOP", GetType(System.String)).DefaultValue = "N"

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub Button18_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button18.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "INKKOP"
        Dim aSelectFields As String = "CRE" + TAB + "DATLEV"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "NR"

        Dim aWhereFields As String = "NR"
        Dim aWhereOperators As String = ">"
        Dim aWhereValues As String = "0"

        Dim aMutDateVa As String = ""
        If CheckBox1.Checked Then aMutDateVa = DateTimePicker1.Value

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridViewArt.Columns.Clear()
                    DataGridViewArt.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 2
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridViewArt.Columns.Clear()
                                DataGridViewArt.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub CheckBox2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox2.CheckedChanged
        Select Case CheckBox2.Checked
            Case True
                txtOmgevingsCode.Text = "00000" : txtOmgevingsCode.Enabled = False
            Case Else
                txtOmgevingsCode.Text = omgevingscode_demoadministratie : txtOmgevingsCode.Enabled = True
        End Select
    End Sub

    Private Sub btn_TotvrijeVoorraad_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_TotvrijeVoorraad.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim ws1 As New ws1.ws1
        Dim foutmelding As String = ""
        Dim ds_records As New DataSet

        Dim ds_selectie As New DataSet
        Dim dt_selectie As DataTable = ds_selectie.Tables.Add
        dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = "INKRG"
        dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = "ART" + TAB + "RG" + TAB + "TOTVRIJVERK" + TAB + "AANT" + TAB + "TOTONTVANGEN" + TAB + "DATLEVBEVESTIGD" + TAB + "DATLEV"
        dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = ""
        dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = ""
        dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = ""
        dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = "ART"
        dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = 0
        dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 20
        dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 2

        Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

        If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
            MsgBox("GetStamtabelRecords TotvrijeVoorraad mislukt: " + foutmelding)
        Else
            DataGridViewArt.Columns.Clear()
            DataGridViewArt.DataSource = ds_records.Tables("DATA")
            LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
        End If
    End Sub

    Private Sub Button19_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button19.Click
        DataGridViewArt.Columns.Clear()

        Dim aTable As String = "GRBMUT"
        Dim aSelectFields As String = "JR" + TAB + "PN" + TAB + "DAGB" + TAB + "RG" + TAB + "BEDR" + TAB + "BOE_OMSCHR"
        Dim aMaxResult As Integer = 0
        Dim aOrderBy As String = "PN"

        Dim aWhereFields As String = ""
        Dim aWhereOperators As String = ""
        Dim aWhereValues As String = ""

        Dim ds_records As New DataSet

        Select Case combometh.SelectedItem
            Case "SOAP"
                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""

                Dim ds_selectie As New DataSet
                Dim dt_selectie As DataTable = ds_selectie.Tables.Add
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                If Not ws1.GetStamtabelRecords(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_selectie, ds_records, foutmelding) Then
                    MsgBox("GetStamtabelRecords mislukt: " + foutmelding)
                Else
                    DataGridView7.Columns.Clear()
                    DataGridView7.DataSource = ds_records.Tables("DATA")
                End If
            Case "XML"
                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim records As String = ""

                ' ophalen grootboekrekeningen.
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim foutmelding As String = ""

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 0
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 0

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString

                If Not ws1_xml.GetStamtabelRecords(partnerkey, omgevingscode_demoadministratie, txtSessionId.Text, selectie, records, foutmelding) Then
                    MsgBox("XML-GetStamTabelRecords mislukt: " + foutmelding)
                Else
                    ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(records)))
                    DataGridView7.Columns.Clear()
                    DataGridView7.DataSource = ds_records.Tables("DATA")
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "GETSTAMTABELRECORDS") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim dt_selectie As New DataTable
                dt_selectie.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTable
                dt_selectie.Columns.Add("SELECTFIELDS", GetType(System.String)).DefaultValue = aSelectFields
                dt_selectie.Columns.Add("WHEREFIELDS", GetType(System.String)).DefaultValue = aWhereFields
                dt_selectie.Columns.Add("WHEREOPERATORS", GetType(System.String)).DefaultValue = aWhereOperators
                dt_selectie.Columns.Add("WHEREVALUES", GetType(System.String)).DefaultValue = aWhereValues
                dt_selectie.Columns.Add("ORDERBY", GetType(System.String)).DefaultValue = aOrderBy
                dt_selectie.Columns.Add("MAXRESULT", GetType(System.Int32)).DefaultValue = aMaxResult
                dt_selectie.Columns.Add("PAGESIZE", GetType(System.Int32)).DefaultValue = 500
                dt_selectie.Columns.Add("SELECTPAGE", GetType(System.Int32)).DefaultValue = 1

                Dim dr_selectie = dt_selectie.NewRow : dt_selectie.Rows.Add(dr_selectie)

                Dim ds_selectie As New DataSet : ds_selectie.Tables.Add(dt_selectie.Copy)
                Dim sw As New IO.StringWriter
                ds_selectie.WriteXml(sw)
                Dim selectie As String = sw.ToString
                valuecollection.Add("SELECTIE", selectie)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("GetStamtabelrecords mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                ds_records.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                                DataGridView7.Columns.Clear()
                                DataGridView7.DataSource = ds_records.Tables("DATA")
                                If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                                    LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
                                Else
                                    LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
                                End If
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select

        If ds_records.Tables.Count > 0 Then
            If ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT") = 0 Then
                LabelArt.Text = "Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString
            Else
                LabelArt.Text = "Aantal records op pagina: " + ds_records.Tables("DATA").Rows.Count.ToString + ". Totaal aantal records: " + ds_records.Tables("METADATA").Rows(0)("RECORDCOUNT").ToString + ", aantal pages: " + ds_records.Tables("METADATA").Rows(0)("TOTALPAGES").ToString
            End If
        End If
    End Sub

    Private Sub Button20_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button20.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim aTabel As String = "ART"
        Dim ds_mutatie As New DataSet
        Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "METADATA"
        dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTabel
        Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)
        Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "DATA"
        dt_data.Columns.Add("NR", GetType(System.String)).DefaultValue = "123456"
        dt_data.Columns.Add("ZKSL", GetType(System.String)).DefaultValue = "Test werksoort"
        dt_data.Columns.Add("ARTGRP", GetType(System.String)).DefaultValue = "1"
        dt_data.Columns.Add("CATEGORIE", GetType(System.String)).DefaultValue = "W"
        dt_data.Columns.Add("BLOKDECL", GetType(System.String)).DefaultValue = "N"
        dt_data.Columns.Add("VERKPR", GetType(System.String)).DefaultValue = "5,00"

        ' overleg met applicatiebeheerder.
        dt_data.Columns.Add("KDR", GetType(System.Int32)).DefaultValue = 1
        dt_data.Columns.Add("KPL", GetType(System.Int32)).DefaultValue = 2
        dt_data.Columns.Add("DECTYPE", GetType(System.String)).DefaultValue = "consultancy"

        Dim dr_data = dt_data.NewRow : dt_data.Rows.Add(dr_data)

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim MessageId() As String = Nothing
                If Not ws1.CreateStamTabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_mutatie, txtNrNieuw.Text, foutmelding) Then
                    MsgBox("Artikel aangemaakt mislukt: " + foutmelding)
                Else
                    MsgBox("Artikel aangemaakt, nr: " + txtNrNieuw.Text)
                    txtDebNr.Text = txtNrNieuw.Text
                End If
            Case "XML"
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim stamtabel As String = sw.ToString

                Dim MessageId() As String = Nothing
                If Not ws1_xml.CreateStamTabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, stamtabel, txtNrNieuw.Text, foutmelding) Then
                    MsgBox("Artikel aangemaakt mislukt: " + foutmelding)
                Else
                    MsgBox("Artikel aangemaakt, nr: " + txtNrNieuw.Text)
                    txtDebNr.Text = txtNrNieuw.Text
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "CREATESTAMTABELRECORD") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim stamtabel As String = sw.ToString

                valuecollection.Add("STAMTABEL", stamtabel)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Artikel aangemaakt mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                txtNrNieuw.Text = ds_return.Tables("TABEL").Rows(0)("PRIMARYKEY")
                                MsgBox("Artikel aangemaakt, nr: " + txtNrNieuw.Text)
                                txtDebNr.Text = txtNrNieuw.Text
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub

    Private Sub Button21_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button21.Click
        If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

        Dim aTabel As String = "INCMANDAAT"
        Dim ds_mutatie As New DataSet
        Dim dt_selection As DataTable = ds_mutatie.Tables.Add : dt_selection.TableName = "METADATA"
        dt_selection.Columns.Add("TABLE", GetType(System.String)).DefaultValue = aTabel
        Dim dr_selection = dt_selection.NewRow : dt_selection.Rows.Add(dr_selection)
        Dim dt_data As DataTable = ds_mutatie.Tables.Add : dt_data.TableName = "DATA"
        dt_data.Columns.Add("DEB", GetType(System.String)).DefaultValue = "10000"
        'dt_data.Columns.Add("ZKSL", GetType(System.String)).DefaultValue = "Test werksoort"
        'dt_data.Columns.Add("ARTGRP", GetType(System.String)).DefaultValue = "1"
        'dt_data.Columns.Add("CATEGORIE", GetType(System.String)).DefaultValue = "W"
        'dt_data.Columns.Add("BLOKDECL", GetType(System.String)).DefaultValue = "N"
        'dt_data.Columns.Add("VERKPR", GetType(System.String)).DefaultValue = "5,00"

        Dim dr_data = dt_data.NewRow : dt_data.Rows.Add(dr_data)

        Select Case combometh.SelectedItem
            Case "SOAP"
                Dim ws1 As New ws1.ws1
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim MessageId() As String = Nothing
                If Not ws1.CreateStamTabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, ds_mutatie, txtNrNieuw.Text, foutmelding) Then
                    MsgBox("Artikel aangemaakt mislukt: " + foutmelding)
                Else
                    MsgBox("Artikel aangemaakt, nr: " + txtNrNieuw.Text)
                    txtDebNr.Text = txtNrNieuw.Text
                End If
            Case "XML"
                If String.IsNullOrEmpty(txtSessionId.Text) Then MsgBox("SessionId is leeg.") : Exit Sub

                Dim ws1_xml As New ws1_xml.ws1_xml
                Dim foutmelding As String = ""
                Dim ds_records As New DataSet

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim stamtabel As String = sw.ToString

                Dim MessageId() As String = Nothing
                If Not ws1_xml.CreateStamTabelRecord(txtPartnerKey.Text, txtOmgevingsCode.Text, txtSessionId.Text, stamtabel, txtNrNieuw.Text, foutmelding) Then
                    MsgBox("Artikel aangemaakt mislukt: " + foutmelding)
                Else
                    MsgBox("Artikel aangemaakt, nr: " + txtNrNieuw.Text)
                    txtDebNr.Text = txtNrNieuw.Text
                End If
            Case "API"
                Dim valuecollection As New NameValueCollection
                valuecollection.Add("partnerkey", txtPartnerKey.Text) : valuecollection.Add("omgevingscode", txtOmgevingsCode.Text)
                valuecollection.Add("ACTIE", "CREATESTAMTABELRECORD") : valuecollection.Add("SESSIONID", txtSessionId.Text)

                Dim sw As New IO.StringWriter
                ds_mutatie.WriteXml(sw)
                Dim stamtabel As String = sw.ToString

                valuecollection.Add("STAMTABEL", stamtabel)

                Try
                    Using client As New Net.WebClient
                        Dim returnbyte() As Byte = client.UploadValues("https://cloudswitch.imuisonline.com/ws1_api.aspx", "post", valuecollection)
                        Dim returnstr As String = System.Text.Encoding.UTF8.GetString(returnbyte)

                        Dim ds_return As New DataSet
                        Try
                            ds_return.ReadXml(New System.Xml.XmlTextReader(New IO.StringReader(returnstr)))
                            If ds_return.Tables.Contains("ERROR") Then
                                MsgBox("Machtiging aangemaakt mislukt: " + ds_return.Tables("ERROR").Rows(0)("MESSAGE"))
                            Else
                                txtNrNieuw.Text = ds_return.Tables("TABEL").Rows(0)("PRIMARYKEY")
                                MsgBox("Machtiging aangemaakt, nr: " + txtNrNieuw.Text)
                                txtDebNr.Text = txtNrNieuw.Text
                            End If
                        Catch ex As Exception
                            MsgBox("return waarde is geen geldige XML: " + ex.ToString)
                        End Try
                    End Using
                Catch ex As Exception

                End Try
        End Select
    End Sub
End Class